@echo off
chcp 65001 >nul
echo 极域电子教室控制系统 - 完整打包脚本
echo ===================================

echo 正在检查必要的EXE文件...
if not exist "Astrum For Online Classroom 4.5.1.exe" (
    echo ❌ 错误: 找不到 Astrum For Online Classroom 4.5.1.exe
    echo 🔧 请确保该文件在当前目录
    pause
    exit /b 1
)

if not exist "my_program.exe" (
    echo ❌ 错误: 找不到 my_program.exe
    echo 🔧 请确保该文件在当前目录
    pause
    exit /b 1
)

echo ✅ 找到所有必要的EXE文件
echo 正在使用Nuitka打包程序...

nuitka ^
--standalone ^
--onefile ^
--windows-console-mode=disable ^
--enable-plugin=tk-inter ^
--include-package=PIL ^
--include-data-file="Astrum For Online Classroom 4.5.1.exe=Astrum For Online Classroom 4.5.1.exe" ^
--include-data-file="my_program.exe=my_program.exe" ^
--output-dir=dist ^
--assume-yes-for-downloads ^
--remove-output ^
--show-progress ^
zong2.py

echo.
if %errorlevel% equ 0 (
    echo ✅ 打包成功完成！
    echo 📁 生成文件: dist\zong2.exe
    echo 💡 包含: Astrum For Online Classroom 4.5.1.exe 和 my_program.exe
) else (
    echo ❌ 打包过程中出现错误
    echo 🔧 请检查错误信息并重试
)

echo.
pause